// priority:100

ServerEvents.recipes(event => {

    const IESlab = (metal,metalBlockToUse) => {
        event
            .shaped(
                '6x immersiveengineering:slab_storage_' + metal,
                ['BBB','   ','   '],
                {
                    B: '#forge:storage_blocks/' + metal,
                }
            )
            .id('immersiveengineering:crafting/storage_' + metal + '_to_slab')

        event
            .shaped(metalBlockToUse,['S ','S '],{
                S: 'immersiveengineering:slab_storage_' + metal,
            })
            .id('immersiveengineering:crafting/storage_' + metal + '_from_slab')
    }

    //recipe replacements
    IESlab('lead','mekanism:block_lead')
    IESlab('silver','occultism:silver_block')
    IESlab('nickel','immersiveengineering:storage_nickel')
    IESlab('electrum','immersiveengineering:storage_electrum')
    IESlab('constantan','immersiveengineering:storage_constantan')
    IESlab('steel','mekanism:block_steel')



    //Pulverizer additions

    const pulverizerAdditions = [
        ['forge:ores/uranium','mekanism:dust_uranium'],
        ['forge:ores/osmium',''],
        ['forge:raw_materials/osmium','mekanism:dust_osmium']
    ]

    pulverizerAdditions.forEach((material) => {
        event.custom({
            "type": "thermal:pulverizer",
            "ingredient": {
                "tag": material[0]
            },
            "result": [
                {
                    "item": material[1],
                    "chance": 2.0
                }
            ],
            "experience": 0.2
        })
    })

    const RawtoRaw = [
        ['immersiveengineering:raw_lead','mekanism:raw_lead'],
        ['thermal:raw_lead','mekanism:raw_lead'],
        ['immersiveengineering:raw_uranium','mekanism:raw_uranium'],
        ['immersiveengineering:raw_silver','occultism:raw_silver'],
        ['thermal:raw_silver','occultism:raw_silver'],
        ['thermal:raw_tin','mekanism:raw_tin'],
        ['thermal:raw_nickel','immersiveengineering:raw_nickel'],
    ]

        RawtoRaw.forEach((ore) => {
          event.replaceOutput({}, ore[0], ore[1])
          event.shapeless(ore[1],[ore[0]])
    })

    const pulverizerAdditionsRaw = [
        ['forge:raw_materials/zinc','jaopca:dusts.zinc'],
        ['forge:raw_materials/aluminum','immersiveengineering:dust_aluminum'],
        ['forge:raw_materials/uranium','mekanism:dust_uranium'],
        ['forge:raw_materials/osmium','mekanism:dust_osmium'],
        ['forge:raw_ores/iesnium','occultism:iesnium_dust']
    ]

    pulverizerAdditionsRaw.forEach((material) => {
        event.custom({
            "type": "thermal:pulverizer",
            "ingredient": {
                "tag": material[0]
            },
            "result": [
                {
                    "item": material[1],
                    "chance": 1.0
                }
            ],
            "experience": 0.2
        })
    })


    //occultism crusher additions
    const oresToDust = [
        ['forge:ores/coal','mekanism:dust_coal'],
        ['forge:ores/iron','mekanism:dust_iron'],
        ['forge:ores/copper','mekanism:dust_copper'],
        ['forge:ores/gold','mekanism:dust_gold'],
        ['forge:ores/redstone','minecraft:redstone'],
        ['forge:ores/emerald','mekanism:dust_emerald'],
        ['forge:ores/diamond','mekanism:dust_diamond'],
        ['forge:ores/lapis','mekanism:dust_lapis_lazuli'],
        ['forge:ores/quartz','mekanism:dust_quartz'],
        ['forge:ores/zinc','jaopca:dusts.zinc'],
        ['forge:ores/uranium','mekanism:dust_uranium'],
        ['forge:ores/tin','mekanism:dust_tin'],
        ['forge:ores/osmium','mekanism:dust_osmium'],
        ['forge:ores/nickel','immersiveengineering:dust_nickel'],
        ['forge:ores/lead','mekanism:dust_lead'],
        ['forge:ores/fluorite','mekanism:dust_fluorite'],
        ['forge:ores/uranite','powah:uraninite_raw'],
        ['forge:raw_materials/coal','mekanism:dust_coal'],
        ['forge:raw_materials/iron','mekanism:dust_iron'],
        ['forge:raw_materials/copper','mekanism:dust_copper'],
        ['forge:raw_materials/gold','mekanism:dust_gold'],
        ['forge:raw_materials/redstone','minecraft:redstone'],
        ['forge:raw_materials/emerald','mekanism:dust_emerald'],
        ['forge:raw_materials/diamond','mekanism:dust_diamond'],
        ['forge:raw_materials/lapis','mekanism:dust_lapis_lazuli'],
        ['forge:raw_materials/quartz','mekanism:dust_quartz'],
        ['forge:raw_materials/zinc','jaopca:dusts.zinc'],
        ['forge:raw_materials/uranium','mekanism:dust_uranium'],
        ['forge:raw_materials/tin','mekanism:dust_tin'],
        ['forge:raw_materials/osmium','mekanism:dust_osmium'],
        ['forge:raw_materials/nickel','immersiveengineering:dust_nickel'],
        ['forge:raw_materials/lead','mekanism:dust_lead'],
        ['forge:raw_materials/fluorite','mekanism:dust_fluorite'],
        ['forge:raw_materials/uranite','powah:uraninite_raw']
    ]

    oresToDust.forEach((material) =>
        event.custom({
            "type": "occultism:crushing",
            "ingredient": {
                "tag": material[0]
            },
            "result": {
                "item": material[1],
                "count": 2
            },
            "crushing_time": 200
        })
    )

    //electrum blocks
    event.shapeless('9x immersiveengineering:ingot_electrum',['thermal:electrum_block'])

    //thermal dust conversions
    const dustToDust = [
        ['thermal:emerald_dust','mekanism:dust_emerald'],
        ['thermal:iron_dust','mekanism:dust_iron'],
        ['thermal:copper_dust','mekanism:dust_copper'],
        ['thermal:gold_dust','mekanism:dust_gold'],
        ['thermal:silver_dust','occultism:silver_dust'],
        ['thermal:lapis_dust','mekanism:dust_lapis_lazuli'],
        ['thermal:diamond_dust','mekanism:dust_diamond'],
        ['thermal:quartz_dust','mekanism:dust_quartz'],
        ['thermal:tin_dust','mekanism:dust_tin'],
        ['thermal:lead_dust','mekanism:dust_lead']
    ]

    dustToDust.forEach((dust) => {
          event.replaceOutput({}, dust[0], dust[1])
          event.shapeless(dust[1],[dust[0]])
    })

    //replace thermal outputs
    const thermalReplacements = [
	    ['thermal:tin_nugget','thermal:copper_nugget'],
	    ['thermal:copper_nugget','mekanism:nugget_tin'],
	    ['thermal:netherite_nugget','cyclic:netherite_nugget'],
	    ['thermal:lead_nugget','mekanism:nugget_lead'],
	    ['thermal:silver_nugget','occultism:silver_nugget'],
	    ['thermal:nickel_nugget','immersiveengineering:nugget_nickel'],
	    ['thermal:electrum_nugget','immersiveengineering:nugget_electrum'],
	    ['thermal:constantan_nugget','immersiveengineering:nugget_constantan']
    ]

    thermalReplacements.forEach((replacement) => {
          event.replaceOutput({}, replacement[0], replacement[1])
    })

    

 })

ServerEvents.tags('item', event => {
    
    global['unUnified'].forEach((id) => {
        event.removeAllTagsFrom(id)
    })
})
